"use client"
import Header from '@/app/Components/Home/Header';
import Sidebar from '@/app/Components/Home/Sidebar';
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import axios from 'axios';
import { getCookie } from 'cookies-next';
import { useRouter } from 'next/navigation';
import React, { useState, useEffect } from 'react';
import { useSelector } from 'react-redux';
import swal from 'sweetalert';
const AssignUserPage = ({ params }) => {
  const [brands, setBrands] = useState([]);
  const [searchQuery, setSearchQuery] = useState('');
  const [isSaveVisible, setIsSaveVisible] = useState(false);
  const { bid } = params;
  // const user = useSelector((state) => state.user.userInfo);
  const router = useRouter();
  const user = useSelector((state) => state.user.userInfo);
  const [UserId, setUserId] = useState(user.userId)
  
  
  // const [isSaveVisible, setisSaveVisible] = useState(false);
  useEffect(() => {
    const token = getCookie('token');

    // Redirect to login if no token is found
    if (!token) {
      router.push('/login');
    } else {
      // const verifyUserRole = async () => {
      //   try {
      //     const response = await axios-post(
      //       `${process.env.NEXT_PUBLIC_API_URL}/api/auth/user-verify-role`,
      //       {},
      //       {
      //         headers: {
      //           Authorization: `Bearer ${token}`,
      //         },
      //       }
      //     );

      //     const { success, userId } = response.data;
      //     setUserId(userId)
          
          
      //   } catch (error) {
      //     console.error('Error verifying user role:', error);
      //     router.push('/login');
      //   }
      // };
      // const verifyUserRole = async () => {
      //   try {
      //     const { success, userId } = await apiRequest('/api/auth/user-verify-role', 'POST');
      //     setUserId(userId);
      //   } catch (error) {
      //     console.error('Error verifying user role:', error);
      //     router.push('/login');
      //   }
      // };
      
      // verifyUserRole();
    }
  }, []);

  useEffect(() => {
    if (!bid || !user.company_id) return;
  
    
  
    // Create the URL with query parameters
    const url = new URL(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/users-assign`);
    
    
    
    url.searchParams.append('brandid', bid);
    url.searchParams.append('company_id', user.company_id);
    url.searchParams.append('filter', false);
  
    // Fetch brands and assigned users data from the backend
    fetch(url, {
      method: 'GET',
    })
      .then((response) => response.json())
      .then((data) => setBrands(data))
      .catch((error) => console.error('Error fetching data:', error));
  }, [bid, user.company_id]);
  

  const handleCheckChange = (userId) => {
    const updatedBrands = brands.map((user) => {
      if (user.user_id === userId) {
        return { ...user, assigned: user.assigned === 1 ? 0 : 1 };
      }
      return user;
    });
    setBrands(updatedBrands);
    setIsSaveVisible(true); // Show the save button when a change is made
  };
  // const handleSave = async () => {

    
    
  //   const dataToSend = {
  //     brandId: bid, // Assuming you have a selected brand
  //     users: brands, // The state containing the users and their assigned status
  //     company_id:user.company_id,
  //     createdBy:UserId
      
  //   };
   
    
  //   try {
  //     const response = await axios-put(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/brands/update-users-assign`, dataToSend);
  //      // Log success message
      
  //       swal("Success!", "User successfully Assigned to Brand.", "success");
       
  //   } catch (error) {
  //     swal("Oops!", "Something Went Wrong, Please try again", "error");
  //     console.error('Error updating assignments:', error);
  //   }
  // };
  const handleSave = async () => {
    const dataToSend = {
      brandId: bid,
      users: brands,
      company_id: user.company_id,
      createdBy: UserId,
    };
  
    try {
      await apiRequest('/api/companies/brands/update-users-assign', 'PUT', dataToSend);
      swal("Success!", "User successfully Assigned to Brand.", "success");
    } catch (error) {
      swal("Oops!", error.message, "error");
    }
  };
  const handleSearch = (e) => {
    
    
    setSearchQuery(e.target.value);
  };

  const filteredBrands = brands.filter((brand) =>
    brand.user_name?.toLowerCase()?.includes(searchQuery.toLowerCase())
  );

  return (
    <>
     
       
        <div className="container-fluid top-bar">
          <div className="left-div">
            <h2>Assign User</h2>
          </div>
          <div className="right-div">
           
             
          </div>
        </div>
        <div className="container-fluid company-header">
          <div className="comp-header-row flex justify-content-between align-items-center">
            <input
              type="text"
              className="form-control w-75 "
              placeholder="Search Brands"
              value={searchQuery}
              onChange={handleSearch}
            />
             {isSaveVisible && (
              <button className="btn p-btn" onClick={handleSave}>
                Save Changes
              </button>
            )}
          </div>
        </div>
        <div className="container-fluid table-container">
          <table className="table table-striped mt-4">
            <thead>
              <tr>
                {/* <th></th> */}
                {/* <th>Brand Name</th> */}
                <th>User</th>
                <th>Assign</th>
              </tr>
            </thead>
            <tbody>
            {filteredBrands.map((user) => (
  <tr key={user.user_id}>
    <td>{user.user_name}</td>
    <td>
      <input
        type="checkbox"
        checked={user.assigned === 1}
        onChange={() => handleCheckChange(user.user_id)}
      />
    </td>
  </tr>
))}

            </tbody>
          </table>
        
        </div>
     
    </>
  );
};

export default AssignUserPage;
